<?php
//Esse arquivo RETORNO.PHP recebe de forma automática os retornos do pagseguro relacionados a suas vendas,
//ou seja, se um pagamento é confirmado o pagseguro acionará esse arquivo.
//A partir daí você poderá rodar ações no seu sistema como enviar um e-mail para o comprador
//avisando que o pagamento foi confirmado e/ou mudando o status da transação no seu banco de dados.

include_once("configuracoes.php");

if($_SERVER['REQUEST_METHOD'] == 'POST'){

$url = "https://ws".$sandbox.".pagseguro.uol.com.br/v2/transactions/notifications/".$_POST['notificationCode']."?email=".$pagseguro_email."&token=".$pagseguro_token;

//Comunicação com o PagSeguro para trazer os dados da transação.
$curl = curl_init($url);
curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
$transaction_curl = curl_exec($curl);
curl_close($curl);

$transaction = simplexml_load_string(utf8_encode($transaction_curl));

//Referência que você enviou para o PagSeguro durante a transação. ID do pedido ou ID do cliente. Esse parámetro é enviado junto com o status do pedido. Com esse parâmetro você conseguirá buscar no banco de dados o pedido/cliente em questão e mudar seu status.
$referencia = $transaction->reference;

//Código da transação gerado pelo PagSeguro. Você pode armazenar esse código em uma coluna no da tabela do pedido em seu banco de dados, é interessante para consultas futuras em seu sistema.
$transacao_pagseguro = $transaction->code;

//Caso o status da transação seja 3 (PAGO) realiza uma ação
if($transaction->status == 3){

	//Aqui você pode realizar qualquer ação em seu sistema quando o status da transação for 03 PAGO. Por exemplo: Atualizar o status do pedido no banco de dados e enviar um e-mail para o cliente.

	$codigo = $transaction->reference;
	$id_pagseguro = $transaction->code;
	require 'bancodedados_.php';
	//aqui faz a operação no banco

	$result = mysqli_query($link, "update pedidos set id_pagseguro = '$id_pagseguro', status = 3 where codigo like '$codigo'");
	
	$sql = mysqli_query($link, "select email from pedidos where codigo like '$codigo'");
	if($row = mysqli_fetch_array($sql)){
	$email = $row['usuario'];
	$to  = ''.$email.'';
	$subject = 'Confirmação de pagamento';
	$message = '
	<html>
	<head>
	  <title>Confirmação de pagamento</title>
	</head>
	<body>
	<table cellpadding="0" cellspacing="0" width="100%" bgcolor="#f4f4f4">
	<tr><td valign="top" width="100%">
	<table style="width: 600px; border:2px solid #e5e5e5" align="center" bgcolor="#ffffff">
	  <tr>
		<td><p><img src="http://www.seusite.com.br/imagens/logorodape.png" /></p></td></tr>
		<tr><td valign="top" width="600px" height="5px" bgcolor="#cf4c3e"></td></tr>
		<tr><td>
		  <p style="text-align:center; margin-top: 20px;">Olá,<br />
			Informamos que seu pagamento foi aprovado e os ingressos liberados.<br />
			Acesse a página <a href="http://www.seusite.com.br/?page=meus-tickets">Meus Tickets</a> e imprima seu voucher!</p><br /><br />
			<p style="text-align:right; margin-right: 20px; padding-bottom: 15px">Atenciosamente,<br />
			Equipe SeuSite
		  </p>
		  </td>
	  </tr>
	</table>
	</td>
	</tr>
	</table>
	</body>
	</html>
	';

	// To send HTML mail, the Content-type header must be set
	$headers  = 'MIME-Version: 1.0' . "\r\n";
	$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

	// Additional headers
	$headers .= 'From: SeuSite <contato@seusite.com.br>' . "\r\n";

	// Mail it
	mail($to, $subject, $message, $headers);
	}
	
}


if($transaction->status == 4){ //status de Disponível
	
	$codigo = $transaction->reference;
	$id_pagseguro = $transaction->code;
	require 'bancodedados_.php';
	//aqui faz a operação no banco

	$result = mysqli_query($link, "update pedidos set id_pagseguro = '$id_pagseguro', status = 4 where codigo = '$codigo'");
	
	if(mysqli_affected_rows($link) > 0){
	echo "Status atualizado com sucesso para Disponível";	
    }
}

//VEJA TODOS OS CÓDIGOS DE STATUS DE TRANSAÇÕES:
// 1 	Aguardando pagamento: o comprador iniciou a transação, mas até o momento o PagSeguro não recebeu nenhuma informação sobre o pagamento.
// 2 	Em análise: o comprador optou por pagar com um cartão de crédito e o PagSeguro está analisando o risco da transação.
// 3 	Paga: a transação foi paga pelo comprador e o PagSeguro já recebeu uma confirmação da instituição financeira responsável pelo processamento.
// 4 	Disponível: a transação foi paga e chegou ao final de seu prazo de liberação sem ter sido retornada e sem que haja nenhuma disputa aberta.
// 5 	Em disputa: o comprador, dentro do prazo de liberação da transação, abriu uma disputa.
// 6 	Devolvida: o valor da transação foi devolvido para o comprador.
// 7 	Cancelada: a transação foi cancelada sem ter sido finalizada.

}
?>
