function download_csv(csv, filename) {
  var csvFile;
  var downloadLink;

  // CSV FILE
  csvFile = new Blob(["\ufeff",csv], {type: "text/csv;charset=UTF-8"});

  // Download link
  downloadLink = document.createElement("a");

  // File name
  downloadLink.download = filename;

  // We have to create a link to the file
  downloadLink.href = window.URL.createObjectURL(csvFile);

  // Make sure that the link is not displayed
  downloadLink.style.display = "none";

  // Add the link to your DOM
  document.body.appendChild(downloadLink);

  // Lanzamos
  downloadLink.click();
}

function export_table_to_csv(html, filename) {
var csv = [];
var rows = document.querySelectorAll("table tr");

  for (var i = 0; i < rows.length; i++) {
  var row = [], cols = rows[i].querySelectorAll("td, th");
  
      for (var j = 0; j < cols.length; j++) 
          row.push(cols[j].innerText);
      
  csv.push(row.join(","));		
}

  // Download CSV
  download_csv(csv.join("\n"), filename);
}

document.getElementById("export").addEventListener("click", function () {
  var html = document.querySelector("table").outerHTML;
  var date1 = document.getElementById('dateInit').value;
  var date2 = document.getElementById('dateFinal').value;
  var nameFile = `${date1}_${date2}.csv`
export_table_to_csv(html, nameFile);
});