<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatório Pagseguro</title>

    <!-- Jquery import -->
    <script
        src="https://code.jquery.com/jquery-3.5.1.min.js"
        integrity="sha256-9/aliU8dGd2tb6OSsuzixeV4y/faTqgFtohetphbbj0="
        crossorigin="anonymous">
    </script>
    <!--  -->

    <!-- Bootstrap import -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-9aIt2nRpC12Uk9gS9baDl411NQApFmC26EwAOH8WgZl5MYYxFfc+NcPb1dKGj7Sk" crossorigin="anonymous">
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.min.js" integrity="sha384-OgVRvuATP1z7JjHLkuOU7Xw704+h835Lr+6QL9UvYjZE3Ipu6Tp75j7Bh/kR0JKI" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/js/bootstrap.bundle.min.js" integrity="sha384-1CmrxMRARb6aLqgBO7yyAxTOQE2AKb9GfXnEo760AUcUmFx3ibVJJAzGytlQcNXd" crossorigin="anonymous"></script>
    <!--  -->    

    <script>
        $(document).ready(function() {
            $('#loadGif').hide();
            $('#export').hide();
            $('#btn').click(function(){
                var dateInit = $("#dateInit").val();
                var dateFinal = $("#dateFinal").val();
                $('#loadGif').show();
                $.post(
                    'call.php',
                    {dateInit: dateInit, dateFinal: dateFinal},
                    function (data) {
                        if(data != null){
                            $('#container').empty();
                            $('#container').append(data);
                            $('#loadGif').hide();
                            $('#export').show();
                        } else {
                            alert('Resultado nulo');
                            $('#loadGif').hide();
                        }
                    }
                )
            })

            /* var now = new Date($.now())
                , year
                , month
                , date
                , hours
                , minutes
                , seconds
                , formattedDateTime
                ;

            year = now.getFullYear();
            month = now.getMonth().toString().length === 1 ? '0' + (now.getMonth() + 1).toString() : now.getMonth() + 1;
            date = now.getDate().toString().length === 1 ? '0' + (now.getDate()).toString() : now.getDate();
            hours = now.getHours().toString().length === 1 ? '0' + now.getHours().toString() : now.getHours();
            minutes = now.getMinutes().toString().length === 1 ? '0' + now.getMinutes().toString() : now.getMinutes();
            seconds = now.getSeconds().toString().length === 1 ? '0' + now.getSeconds().toString() : now.getSeconds();

            formattedDateTime = year + '-' + month + '-' + date + 'T' + hours + ':' + minutes + ':' + seconds;

            $('#dateFinal').val(formattedDateTime); */
        })
            
    </script>
    <style>
        th {
            text-align: left;
            color: #4679bd;
        }

        tbody > tr:nth-of-type(even) {
            background-color: #daeaff;
        }

        #searchContainer {
            margin: 0 auto;
            width: 100%;
            display: flex;
            flex-direction: column;
            padding: 25px;
            margin-bottom: 35px;
            justify-content: center;
            align-items: center;
        }
        #searchContainer input {
            width: 230px;
            height: 59px;
            font-size: 17px;
            margin-bottom: 7px;
        }

        #searchContainer button {
            /* width: 200px;
            border: none; */
            color: #fff;
            background-color: #98b827;
            font-size: 23px;
        }

        #loadGif {
            margin: 10px auto;
            width: 25px;
        }
    </style>
</head>
<body>

<div id="searchContainer">
    <label for="dateInit">Data início</label>    
    <input type="date" name="dateInit" id="dateInit">
    <label for="dateFinal">Data final</label>
    <input type="datetime-local" name="dateFinal" id="dateFinal">
    <button id="btn" class="btn">Buscar</button>
    <img src="load.gif" alt="load gif" id="loadGif">
</div>
<button id="export" class='btn btn-primary'>Exportar CSV</button>
<div id="container"></div>

        <script src="exportCsv.js"></script>
</body>
</html>
